/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::
::   Module      :   ERI Request tables
::   Copyright   :   (C)2003-2009 Woodward
::   Platform(s) :   MPC5xx
::   Dependants  :   TDBParser
::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/

#ifndef __ERIREQUESTTABLES_H
#define __ERIREQUESTTABLES_H

/* --- INCLUDE FILES ----------------------------------------------------------------------------------------*/
#include <typedefn.h>

/* --- DEFINES ----------------------------------------------------------------------------------------------*/
#define ERI_REQUEST_NUM_TBL 8

/* TRUE/FALSE describes whether the result is Floating Point and Signed */
#define UINT1   FALSE,FALSE,0x01
#define INT1    FALSE,TRUE,0x01
#define SINT1   FALSE,TRUE,0x01
#define TXTCHAR FALSE,FALSE,0x01

#define UINT2   FALSE,FALSE,0x02
#define INT2    FALSE,TRUE,0x02
#define SINT2   FALSE,TRUE,0x02
               
#define UINT3   FALSE,FALSE,0x03
#define INT3    FALSE,TRUE,0x03
#define SINT3   FALSE,TRUE,0x03

#define UINT4   FALSE,FALSE,0x04
#define INT4    FALSE,TRUE,0x04
#define SINT4   FALSE,TRUE,0x04
#define REAL4   TRUE,TRUE,0x04

#define REAL8   TRUE,TRUE,0x08

#define NA1 0x00        
#define RO1 0x01        
#define WO1 0x02        
#define RW1 0x03        
#define NA2 0x00        
#define RO2 0x04        
#define WO2 0x08        
#define RW2 0x0C        
#define NA3 0x00        
#define RO3 0x10        
#define WO3 0x20        
#define RW3 0x30        
#define NA4 0x00        
#define RO4 0x40        
#define WO4 0x80        
#define RW4 0xC0        

#define VAR         FALSE,CLASS_VAR
#define VAROFST     FALSE,CLASS_VAR     /* A Var Offset is just a fancy VAR */
#define BITVAR      FALSE,CLASS_VAR
#define TEXT        FALSE,CLASS_TEXT
#define MAP         FALSE,CLASS_MAP
#define TBL         FALSE,CLASS_TBL
#define ORDARR      FALSE,CLASS_ORDARR
#define ARRAY       FALSE,CLASS_ARRAY
#define ENUMARR     FALSE,CLASS_ENUMARR
#define ENUMVAR     FALSE,CLASS_VAR

#define VAR_PTR     TRUE,CLASS_VAR
#define VAROFST_PTR TRUE,CLASS_VAR
#define BITVAR_PTR  TRUE,CLASS_VAR
#define TEXT_PTR    TRUE,CLASS_TEXT
#define MAP_PTR     TRUE,CLASS_MAP
#define TBL_PTR     TRUE,CLASS_TBL
#define ORDARR_PTR  TRUE,CLASS_ORDARR
#define ARRAY_PTR   TRUE,CLASS_ARRAY
#define ENUMARR_PTR TRUE,CLASS_ENUMARR
#define ENUMVAR_PTR TRUE,CLASS_VAR


/* --- TYPEDEF --------------------------------------------------------------------------------------------*/
#pragma pack(1)
typedef enum
{
    CODE,
    RAM,
    FLASH,
    EE,
} E_VarDecStorage;

typedef enum
{
    CLASS_VAR,
    CLASS_TEXT,
    CLASS_MAP,
    CLASS_TBL,
    CLASS_ORDARR,
    CLASS_ARRAY,
    CLASS_ENUMARR,
} E_VarDecClass;

typedef enum
{
    TYPE_UINT1,
    TYPE_SINT1,
    TYPE_UINT2,
    TYPE_SINT2,
    TYPE_UINT3,
    TYPE_SINT3,
    TYPE_UINT4,
    TYPE_SINT4,
    TYPE_REAL4,
    TYPE_REAL8,
} E_VarDecTypes;

/* Structure of an ERI REQUEST table */ 
typedef struct  
{   
    void  *ParamAddress;
    uint4 Access                   :8;
    uint4 bIsPtr                   :1;
    E_VarDecClass eClass           :3;
    uint4 Size                     :12;
    E_VarDecStorage StorageClass   :2;
    uint4 bIsFloatPoint            :1;
    uint4 bIsSigned                :1;
    uint4 uElementSize             :4;
} S_EriRequestTable;

typedef S_EriRequestTable const* EriRequestTablePtr;

/* Check if the __ERI_REV has been defined. If not, default to rev 15 */

#ifndef __ERI_REV
	#define __ERI_REV 15
    #warning Defaulting to __ERI_REV 15, Are you using a compatible library?
#endif

#if __ERI_REV == 14
    #warning Using __ERI_REV 14, Are you using a compatible library?

typedef struct
{
    EriRequestTablePtr TblAddr;
    uint1 TblLength;
} S_EriReqTblList;   

#elif __ERI_REV >= 15

typedef struct
{
    EriRequestTablePtr TblAddr;
    uint2 TblLength;
} S_EriReqTblList;   

#endif

#pragma pack()
/* --- GLOBAL VARIABLE EXTERN -------------------------------------------------------------------------------*/

/* --- FUNCTION PROTOTYPES ----------------------------------------------------------------------------------*/
S_EriReqTblList const* GetERIRequestTablePtr(uint1 table);
#endif /* __ERIREQUESTTABLES_H */

